﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/


using GE.Visualisation;
using GE.Physics.Shapes;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    /// <summary>
    /// Represent a platform
    /// </summary>
    class PlatformEntity : WorldEntity
    {
        /// <summary>
        /// Texture id
        /// </summary>
        int _iIdTexture;

        /// <summary>
        /// Sprite id
        /// </summary>
        int _iIdSprite;

        /// <summary>
        /// Static rectangle
        /// </summary>
        StaticShapeRectangle _physicShape;

        /// <summary>
        /// Constructor
        /// </summary>
        public PlatformEntity()
        {
            _entityType = eEntityType.eEntityPlatform;
            _iIdSprite = -1;
            _iIdTexture = -1;
            _v2Position = Vector2.Zero;
        }

        /// <summary>
        /// Activator
        /// </summary>
        /// <param name="idTexture">Texture id</param>
        /// <param name="spriteName">Sprite id</param>
        /// <param name="position">Platform's position</param>
        public void activate(int idTexture, string spriteName, Vector2 position)
        {
            _iIdTexture = idTexture;
            _iIdSprite = Visu.Instance.getSpriteId(_iIdTexture, spriteName);
            _v2Position = position;
            _v2PreviousPosition = position;
            int physicShapeWidth = Visu.Instance.getSpriteWidth(_iIdTexture, _iIdSprite)-10;
            int physicShapeHeight = Visu.Instance.getSpriteHeight(_iIdTexture, _iIdSprite)-10;
            _physicShape = Physics.Physics.Instance.createStaticRectangle(physicShapeWidth, physicShapeHeight, new Vector2(-5, -5), position, 0, this);
            _physicShape._iGroup = (int)ePhysicGroup.ePhysicPlatform;

            _bActive = true;
        }

        /// <summary>
        /// Update
        /// </summary>
        public override void update()
        {
        }

        /// <summary>
        /// Render
        /// </summary>
        public override void render()
        {
            Visu.Instance.displaySprite(_iIdTexture, _iIdSprite, ScreenPosition);

#if DEBUG

            Vector2[] obb = new Vector2[4];
            System.Array.Copy(_physicShape.getOrientedBoundingBox(), obb, 4);
            for (int i = 0; i < 4; i++)
                obb[i] -= World.Instance.CameraPosition;
            
            Visu.Instance.displayPolygon(obb);
#endif
        }

        /// <summary>
        /// Die
        /// </summary>
        public override void die()
        {
        }
    }
}
